package ru.yandex.webmaster3.api.searchurls.action;

import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiPaginationRequest;
import ru.yandex.webmaster3.api.searchurls.SearchUrlEventSamplesLocator;
import ru.yandex.webmaster3.storage.host.HostDataState;

/**
 * @author avhaliullin
 */
public class SearchUrlEventSamplesRequest extends AbstractApiUserVerifiedHostRequest<SearchUrlEventSamplesLocator>
        implements IndexedHostRequest, ApiPaginationRequest {
    private HostDataState hostDataState;
    private int offset;
    private int limit;

    @Override
    public HostDataState getHostDataState() {
        return hostDataState;
    }

    @Override
    public void setHostDataState(HostDataState hostDataState) {
        this.hostDataState = hostDataState;
    }

    @Override
    public int getOffset() {
        return offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLimit() {
        return limit;
    }

    @Override
    @MaxValue(100)
    public void setLimit(int limit) {
        this.limit = limit;
    }
}
