package ru.yandex.webmaster3.api.searchurls.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.searchurls.data.ApiSearchEventSample;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SearchUrlEventSamplesResponse extends ApiResponse.Success200 {
    private final int count;
    private final List<ApiSearchEventSample> samples;

    public SearchUrlEventSamplesResponse(int count, List<ApiSearchEventSample> samples) {
        this.count = count;
        this.samples = samples;
    }

    @Description("общее количество доступных примеров")
    public int getCount() {
        return count;
    }

    @Description("примеры событий")
    public List<ApiSearchEventSample> getSamples() {
        return samples;
    }
}
