package ru.yandex.webmaster3.api.searchurls.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.common.data.ApiHistoryPoint;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.searchurls.data.ApiSearchEventEnum;

import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class SearchUrlEventsHistoryResponse extends ApiResponse.Success200 {
    private final Map<ApiSearchEventEnum, List<ApiHistoryPoint<Long>>> indicators;

    public SearchUrlEventsHistoryResponse(Map<ApiSearchEventEnum, List<ApiHistoryPoint<Long>>> indicators) {
        this.indicators = indicators;
    }

    @Description("история количества страниц сайта, добавленных/удаленных с поиска в определенную дату")
    public Map<ApiSearchEventEnum, List<ApiHistoryPoint<Long>>> getIndicators() {
        return indicators;
    }
}
