package ru.yandex.webmaster3.api.searchurls.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.searchurls.data.ApiSearchUrlSample;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SearchUrlSamplesResponse extends ApiResponse.Success200 {
    private final int count;
    private final List<ApiSearchUrlSample> samples;

    public SearchUrlSamplesResponse(int count, List<ApiSearchUrlSample> samples) {
        this.count = count;
        this.samples = samples;
    }

    @Description("общее количество доступных примеров")
    public int getCount() {
        return count;
    }

    @Description("примеры страниц")
    public List<ApiSearchUrlSample> getSamples() {
        return samples;
    }
}
