package ru.yandex.webmaster3.api.searchurls.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.searchurl.history.data.SearchUrlHistoryIndicator;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlEventType;

/**
 * @author avhaliullin
 */
public enum ApiSearchEventEnum {
    @Description("страница появилась на поиске")
    APPEARED_IN_SEARCH,
    @Description("страница выпала из поиска")
    REMOVED_FROM_SEARCH,
    ;

    public static ApiSearchEventEnum fromSearchUrlHistoryIndicator(SearchUrlHistoryIndicator indicator) {
        switch (indicator) {
            case NEW:
                return APPEARED_IN_SEARCH;

            case GONE:
                return REMOVED_FROM_SEARCH;

            default:
                throw new RuntimeException("Unexpected event: " + indicator);
        }
    }

    public static ApiSearchEventEnum fromSearchUrlEventType(SearchUrlEventType eventType) {
        switch (eventType) {
            case GONE:
                return REMOVED_FROM_SEARCH;

            case NEW:
                return APPEARED_IN_SEARCH;

            default:
                throw new RuntimeException("Unexpected event: " + eventType);
        }
    }
}
