package ru.yandex.webmaster3.api.searchurls.data;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.storage.searchurl.samples.data.SearchUrlSample;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author avhaliullin
 */
public class ApiSearchUrlSample {
// в web ui есть еще дата поисковой базы
    private final URL url;
    private final DateTime lastAccess;
    private final String title;

    public ApiSearchUrlSample(URL url, DateTime lastAccess, String title) {
        this.url = url;
        this.lastAccess = lastAccess;
        this.title = title;
    }

    @Description("адрес страницы")
    public URL getUrl() {
        return url;
    }

    @Description("дата версии страницы в поиске")
    public DateTime getLastAccess() {
        return lastAccess;
    }

    @Description("заголовок страницы")
    public String getTitle() {
        return title;
    }

    @Nullable
    public static ApiSearchUrlSample fromSearchUrlSample(SearchUrlSample sample) {
        URL fullUrl;
        try {
            fullUrl = new URL(sample.getUrl());
        } catch (MalformedURLException e) {
            // should not happen
            return null;
        }

        DateTime lastAccess = sample.getLastAccessDateTime().toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE);
        return new ApiSearchUrlSample(fullUrl, lastAccess, sample.getTitle());
    }
}
