package ru.yandex.webmaster3.api.sitemap;

import ru.yandex.webmaster3.api.http.common.request.locator.AbstractHostLocator;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public class SitemapListLocator extends AbstractHostLocator {
    private final Optional<ApiSitemapId> parentId;

    public SitemapListLocator(long userId, WebmasterHostId hostId, Optional<ApiSitemapId> parentId) {
        super(userId, hostId);
        this.parentId = parentId;
    }

    public Optional<ApiSitemapId> getParentId() {
        return parentId;
    }
}
