package ru.yandex.webmaster3.api.sitemap.action;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.meta.ApiRequestWithEntity;
import ru.yandex.webmaster3.api.sitemap.UserAddedSitemapListLocator;

import java.net.URL;

/**
 * @author avhaliullin
 */
public class AddSitemapRequest extends AbstractApiUserVerifiedHostRequest<UserAddedSitemapListLocator>
        implements ApiRequestWithEntity<AddSitemapRequest.Entity> {
    private Entity entity;

    @Override
    public Entity getEntity() {
        return entity;
    }

    @Override
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public static class Entity {
        private final URL url;

        @JsonCreator
        public Entity(@Description("URL добавляемого файла сайтмеп") URL url) {
            this.url = url;
        }

        public URL getUrl() {
            return url;
        }
    }
}
