package ru.yandex.webmaster3.api.sitemap.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiPostResponse;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.meta.ResponseWithLocation;
import ru.yandex.webmaster3.api.sitemap.UserAddedSitemapLocator;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public interface AddSitemapResponse extends ApiPostResponse {
    class NormalResponse extends ApiResponse.Created201<UserAddedSitemapLocator> implements AddSitemapResponse {
        private final long userId;
        private final WebmasterHostId hostId;
        private final ApiSitemapId sitemapId;

        public NormalResponse(long userId, WebmasterHostId hostId, ApiSitemapId sitemapId) {
            this.userId = userId;
            this.hostId = hostId;
            this.sitemapId = sitemapId;
        }

        @Description("id добавленного сайтмепа")
        public ApiSitemapId getSitemapId() {
            return sitemapId;
        }

        @Override
        public UserAddedSitemapLocator getLocation() {
            return new UserAddedSitemapLocator(userId, hostId, sitemapId);
        }
    }

    enum Errors implements ApiErrorCode {
        SITEMAP_ALREADY_ADDED,
    }

    @Description("Сайтмеп уже добавлен пользователем в список")
    class SitemapAlreadyAddedResponse extends Conflict409<Errors> implements AddSitemapResponse, ResponseWithLocation<UserAddedSitemapLocator> {
        private final long userId;
        private final WebmasterHostId hostId;
        private final ApiSitemapId sitemapId;

        public SitemapAlreadyAddedResponse(long userId, WebmasterHostId hostId, ApiSitemapId sitemapId) {
            super(Errors.SITEMAP_ALREADY_ADDED, "Sitemap already added with id \"" + sitemapId + "\"");
            this.userId = userId;
            this.hostId = hostId;
            this.sitemapId = sitemapId;
        }

        @Description("id сайтмепа, который уже добавлен")
        public ApiSitemapId getSitemapId() {
            return sitemapId;
        }

        @Override
        public UserAddedSitemapLocator getLocation() {
            return new UserAddedSitemapLocator(userId, hostId, sitemapId);
        }
    }
}
