package ru.yandex.webmaster3.api.sitemap.action;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.sitemap.UserSitemapService;

/**
 * @author avhaliullin
 */
@Description("Удалить добавленный пользователем сайтмеп")
@Category("sitemap")
@Component
public class DeleteSitemapAction extends AbstractApiAction<DeleteSitemapRequest, DeleteSitemapResponse> {
    private UserSitemapService userSitemapService;

    public DeleteSitemapAction() {
        super(Permission.COMMON);
    }

    @Override
    public DeleteSitemapResponse process(DeleteSitemapRequest request) {
        userSitemapService.deleteUserSitemap(request.getHostId(), request.getUserSitemap().getSitemapId());
        return new DeleteSitemapResponse();
    }

    @Required
    public void setUserSitemapService(UserSitemapService userSitemapService) {
        this.userSitemapService = userSitemapService;
    }
}
