package ru.yandex.webmaster3.api.sitemap.action;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.ActionPermission;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapSource;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapType;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.sitemap.HostSitemap;
import ru.yandex.webmaster3.core.sitemap.SitemapInfo;
import ru.yandex.webmaster3.storage.sitemap.dao.SitemapsCHDao;

/**
 * @author avhaliullin
 */
@Description("Получить информацию о файле sitemap")
@Category("sitemap")
@Component
@ActionPermission(Permission.COMMON)
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetSitemapInfoAction extends AbstractApiAction<GetSitemapInfoRequest, GetSitemapInfoResponse> {

    private final SitemapsCHDao sitemapsCHDao;

    @Override
    public GetSitemapInfoResponse process(GetSitemapInfoRequest request) {
        ApiSitemapId sitemapId = request.getSitemapId();
        HostSitemap sitemap = sitemapsCHDao.getSitemap(request.getHostId(), sitemapId.getParentId(), sitemapId.getId())
                    .map(SitemapInfo::toHostSitemap).orElse(null);
        if (sitemap == null) {
            return new GetSitemapInfoResponse.SitemapNotFoundResponse(request.getHostId(), sitemapId);
        }

        return new GetSitemapInfoResponse.NormalResponse(
                sitemapId,
                sitemap.getSitemapUrl(),
                sitemap.getInfo().getLastAccessDate(),
                sitemap.getInfo().getErrorsCount(),
                sitemap.getInfo().getUrlsCount(),
                sitemap.getInfo().getChildrenCount(),
                ApiSitemapSource.fromSources(sitemap.getInfo().getSources()),
                sitemap.getInfo().isIndex() ? ApiSitemapType.INDEX_SITEMAP : ApiSitemapType.SITEMAP
        );
    }

}
