package ru.yandex.webmaster3.api.sitemap.action;

import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.LoadedHostRequest;
import ru.yandex.webmaster3.api.sitemap.SitemapLocator;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.storage.host.HostDataState;

/**
 * @author avhaliullin
 */
public class GetSitemapInfoRequest extends AbstractApiUserVerifiedHostRequest<SitemapLocator> implements LoadedHostRequest {
    private HostDataState hostDataState;

    public ApiSitemapId getSitemapId() {
        return getLocator().getSitemapId();
    }

    @Override
    public HostDataState getHostDataState() {
        return hostDataState;
    }

    @Override
    public void setHostDataState(HostDataState hostDataState) {
        this.hostDataState = hostDataState;
    }
}
