package ru.yandex.webmaster3.api.sitemap.action;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapSource;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapType;
import ru.yandex.webmaster3.api.sitemap.data.ISitemapInfo;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Set;

/**
 * @author avhaliullin
 */
public interface GetSitemapInfoResponse extends ApiGetResponse {
    class NormalResponse extends ApiResponse.Success200 implements GetSitemapInfoResponse, ISitemapInfo {
        private final ApiSitemapId sitemapId;
        private final String sitemapUrl;
        private final DateTime lastAccessDate;
        private final int errorsCount;
        private final long urlsCount;
        private final int childrenCount;
        private final Set<ApiSitemapSource> sources;
        private final ApiSitemapType sitemapType;

        public NormalResponse(ApiSitemapId sitemapId, String sitemapUrl,
                              DateTime lastAccessDate, int errorsCount, long urlsCount, int childrenCount,
                              Set<ApiSitemapSource> sources, ApiSitemapType sitemapType) {
            this.sitemapId = sitemapId;
            this.sitemapUrl = sitemapUrl;
            this.lastAccessDate = lastAccessDate;
            this.errorsCount = errorsCount;
            this.urlsCount = urlsCount;
            this.childrenCount = childrenCount;
            this.sources = sources;
            this.sitemapType = sitemapType;
        }

        @Override
        public ApiSitemapId getSitemapId() {
            return sitemapId;
        }

        @Override
        public String getSitemapUrl() {
            return sitemapUrl;
        }

        @Override
        public DateTime getLastAccessDate() {
            return lastAccessDate;
        }

        @Override
        public int getErrorsCount() {
            return errorsCount;
        }

        @Override
        public long getUrlsCount() {
            return urlsCount;
        }

        @Override
        public int getChildrenCount() {
            return childrenCount;
        }

        @Override
        public Set<ApiSitemapSource> getSources() {
            return sources;
        }

        @Override
        public ApiSitemapType getSitemapType() {
            return sitemapType;
        }
    }

    enum Errors implements ApiErrorCode {
        SITEMAP_NOT_FOUND,
    }

    @Description("Указанный sitemap не найден для сайта")
    class SitemapNotFoundResponse extends ApiResponse.NotFound404<Errors> implements GetSitemapInfoResponse {
        private final WebmasterHostId hostId;
        private final ApiSitemapId sitemapId;

        public SitemapNotFoundResponse(WebmasterHostId hostId, ApiSitemapId sitemapId) {
            super(Errors.SITEMAP_NOT_FOUND, "Sitemap " + sitemapId + " not found for host " + hostId);
            this.hostId = hostId;
            this.sitemapId = sitemapId;
        }

        @Description("id сайта")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("id запрошенного sitemap'а")
        public ApiSitemapId getSitemapId() {
            return sitemapId;
        }
    }
}
