package ru.yandex.webmaster3.api.sitemap.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.annotations.MinValue;
import ru.yandex.webmaster3.api.sitemap.SitemapListLocator;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;

/**
 * @author avhaliullin
 */
public class GetSitemapListRequest extends AbstractApiUserVerifiedHostRequest<SitemapListLocator> {
    private int limit = 10;
    private ApiSitemapId from;

    public ApiSitemapId getFrom() {
        return from;
    }

    @Description("Показать сайтмепы начиная с указанного (exclusive)")
    @RequestQueryProperty
    public void setFrom(ApiSitemapId from) {
        this.from = from;
    }

    public int getLimit() {
        return limit;
    }

    @MinValue(1)
    @MaxValue(100)
    @Description("Размер страницы")
    @RequestQueryProperty
    public void setLimit(int limit) {
        this.limit = limit;
    }
}
