package ru.yandex.webmaster3.api.sitemap.action;

import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.metrics.Category;

/**
 * @author avhaliullin
 */
@Description("Получить информацию о добавленном пользователем сайтмепе")
@Category("sitemap")
@Component
public class GetUserAddedSitemapAction extends AbstractApiAction<GetUserAddedSitemapRequest, GetUserAddedSitemapResponse> {
    public GetUserAddedSitemapAction() {
        super(Permission.COMMON);
    }

    @Override
    public GetUserAddedSitemapResponse process(GetUserAddedSitemapRequest request) {
        return new GetUserAddedSitemapResponse(
                request.getSitemapId(),
                request.getUserSitemap().getSitemapUrl(),
                request.getUserSitemap().getAddDate()
        );
    }
}
