package ru.yandex.webmaster3.api.sitemap.action;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.api.sitemap.data.ApiUserAddedSitemap;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.sitemap.UserSitemap;
import ru.yandex.webmaster3.storage.sitemap.UserSitemapService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
@Description("Получить список сайтмепов, добавленных пользователем")
@Category("sitemap")
@Component
public class GetUserAddedSitemapListAction extends AbstractApiAction<GetUserAddedSitemapListRequest, GetUserAddedSitemapListResponse> {
    private UserSitemapService userSitemapService;

    public GetUserAddedSitemapListAction() {
        super(Permission.COMMON);
    }

    @Override
    public GetUserAddedSitemapListResponse process(GetUserAddedSitemapListRequest request) {
        List<UserSitemap> allUserSitemaps = userSitemapService.listUserSitemaps(request.getHostId());
        List<UserSitemap> nonDeleted = allUserSitemaps
                .stream()
                .filter(sitemap -> !sitemap.isDeleted())
                .collect(Collectors.toList());

        List<ApiUserAddedSitemap> sitemapsToDisplay = nonDeleted
                .stream()
                .skip(request.getOffset())
                .limit(request.getLimit())
                .map(ApiUserAddedSitemap::fromUserSitemap)
                .collect(Collectors.toList());
        return new GetUserAddedSitemapListResponse(sitemapsToDisplay, nonDeleted.size());
    }

    @Required
    public void setUserSitemapService(UserSitemapService userSitemapService) {
        this.userSitemapService = userSitemapService;
    }
}
