package ru.yandex.webmaster3.api.sitemap.action;

import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiPaginationRequest;
import ru.yandex.webmaster3.api.sitemap.UserAddedSitemapListLocator;

/**
 * @author avhaliullin
 */
public class GetUserAddedSitemapListRequest extends AbstractApiUserVerifiedHostRequest<UserAddedSitemapListLocator>
        implements ApiPaginationRequest {
    private int offset = 0;
    private int limit = 100;

    @Override
    public int getOffset() {
        return offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLimit() {
        return limit;
    }

    @Override
    @MaxValue(100)
    public void setLimit(int limit) {
        this.limit = limit;
    }
}
