package ru.yandex.webmaster3.api.sitemap.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.sitemap.data.ApiUserAddedSitemap;

import java.util.List;

/**
 * @author avhaliullin
 */
public class GetUserAddedSitemapListResponse extends ApiResponse.Success200 {
    private final List<ApiUserAddedSitemap> sitemaps;
    private final int count;

    public GetUserAddedSitemapListResponse(List<ApiUserAddedSitemap> sitemaps, int count) {
        this.sitemaps = sitemaps;
        this.count = count;
    }

    @Description("Список сайтмепов, добавленных пользователем")
    public List<ApiUserAddedSitemap> getSitemaps() {
        return sitemaps;
    }

    @Description("Общее количество сайтмепов, добавленных пользователем")
    public int getCount() {
        return count;
    }
}
