package ru.yandex.webmaster3.api.sitemap.action;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.api.sitemap.data.IUserAddedSitemap;

/**
 * @author avhaliullin
 */
public class GetUserAddedSitemapResponse extends ApiResponse.Success200 implements IUserAddedSitemap {
    private final ApiSitemapId sitemapId;
    private final String sitemapUrl;
    private final DateTime addedDate;

    public GetUserAddedSitemapResponse(ApiSitemapId sitemapId, String sitemapUrl, DateTime addedDate) {
        this.sitemapId = sitemapId;
        this.sitemapUrl = sitemapUrl;
        this.addedDate = addedDate;
    }

    @Override
    public ApiSitemapId getSitemapId() {
        return sitemapId;
    }

    @Override
    public String getSitemapUrl() {
        return sitemapUrl;
    }

    @Override
    public DateTime getAddedDate() {
        return addedDate;
    }
}
