package ru.yandex.webmaster3.api.sitemap.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.sitemap.HostSitemap;

import java.util.Set;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class ApiSitemapInfo implements ISitemapInfo {
    private final ApiSitemapId sitemapId;
    private final String sitemapUrl;
    private final DateTime lastAccessDate;
    private final int errorsCount;
    private final long urlsCount;
    private final int childrenCount;
    private final Set<ApiSitemapSource> sources;
    private final ApiSitemapType sitemapType;

    public ApiSitemapInfo(ApiSitemapId sitemapId, String sitemapUrl, DateTime lastAccessDate,
                          int errorsCount, long urlsCount, int childrenCount, Set<ApiSitemapSource> sources,
                          ApiSitemapType sitemapType) {
        this.sitemapId = sitemapId;
        this.sitemapUrl = sitemapUrl;
        this.lastAccessDate = lastAccessDate;
        this.errorsCount = errorsCount;
        this.urlsCount = urlsCount;
        this.childrenCount = childrenCount;
        this.sources = sources;
        this.sitemapType = sitemapType;
    }

    @Override
    public ApiSitemapId getSitemapId() {
        return sitemapId;
    }

    @Override
    public String getSitemapUrl() {
        return sitemapUrl;
    }

    @Override
    public DateTime getLastAccessDate() {
        return lastAccessDate;
    }

    @Override
    public int getErrorsCount() {
        return errorsCount;
    }

    @Override
    public long getUrlsCount() {
        return urlsCount;
    }

    @Override
    public Set<ApiSitemapSource> getSources() {
        return sources;
    }

    @Override
    public int getChildrenCount() {
        return childrenCount;
    }

    @Override
    public ApiSitemapType getSitemapType() {
        return sitemapType;
    }

    public static ApiSitemapInfo fromHostSitemap(UUID parentId, HostSitemap sitemap) {
        return new ApiSitemapInfo(
                new ApiSitemapId(parentId, sitemap.getSitemapId()),
                sitemap.getSitemapUrl(),
                sitemap.getInfo().getLastAccessDate(),
                sitemap.getInfo().getErrorsCount(),
                sitemap.getInfo().getUrlsCount(),
                sitemap.getInfo().getChildrenCount(),
                ApiSitemapSource.fromSources(sitemap.getInfo().getSources()),
                sitemap.getInfo().isIndex() ? ApiSitemapType.INDEX_SITEMAP : ApiSitemapType.SITEMAP
        );
    }
}
