package ru.yandex.webmaster3.api.sitemap.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.sitemap.raw.HostRelatedSitemaps;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

/**
 * @author avhaliullin
 */
public enum ApiSitemapSource {
    @Description("Sitemap указан в файле robots.txt сайта")
    ROBOTS_TXT,
    @Description("Sitemap добавлен пользователем в Я.Вебмастере")
    WEBMASTER,
    @Description("Sitemap найден в другом (индексном) файле sitemap")
    INDEX_SITEMAP,;

    public static Set<ApiSitemapSource> fromSources(Collection<HostRelatedSitemaps.SitemapSource> sources) {
        Set<ApiSitemapSource> result = EnumSet.noneOf(ApiSitemapSource.class);
        for (HostRelatedSitemaps.SitemapSource source : sources) {
            switch (source) {
                case ROBOTS_TXT:
                    result.add(ROBOTS_TXT);
                    break;
                case SITEMAP_INDEX:
                    result.add(INDEX_SITEMAP);
                    break;
                case WEBMASTER:
                    result.add(WEBMASTER);
                    break;
                case UNKNOWN:
                    //???
                    break;
                default:
                    throw new RuntimeException("Unknown sitemap source " + source);
            }
        }
        return result;
    }
}
