package ru.yandex.webmaster3.api.sitemap.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.sitemap.UserSitemap;

/**
 * @author avhaliullin
 */
public class ApiUserAddedSitemap implements IUserAddedSitemap {
    private final ApiSitemapId sitemapId;
    private final String sitemapUrl;
    private final DateTime addedDate;

    public ApiUserAddedSitemap(ApiSitemapId sitemapId, String sitemapUrl, DateTime addedDate) {
        this.sitemapId = sitemapId;
        this.sitemapUrl = sitemapUrl;
        this.addedDate = addedDate;
    }

    @Override
    public ApiSitemapId getSitemapId() {
        return sitemapId;
    }

    @Override
    public String getSitemapUrl() {
        return sitemapUrl;
    }

    @Override
    public DateTime getAddedDate() {
        return addedDate;
    }

    public static ApiUserAddedSitemap fromUserSitemap(UserSitemap sitemap) {
        return new ApiUserAddedSitemap(
                new ApiSitemapId(null, sitemap.getSitemapId()),
                sitemap.getSitemapUrl(),
                sitemap.getAddDate()
        );
    }
}
