package ru.yandex.webmaster3.api.sitemap.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public interface ISitemapInfo {
    @Description("id файла sitemap")
    ApiSitemapId getSitemapId();

    @Description("URL файла sitemap")
    String getSitemapUrl();

    @Description("Дата последней загрузки")
    DateTime getLastAccessDate();

    @Description("Количество ошибок")
    int getErrorsCount();

    @Description("Количество ссылок в файле")
    long getUrlsCount();

    @Description("Источники, из которых робот узнал об этом файле")
    Set<ApiSitemapSource> getSources();

    @Description("Количество дочерних файлов sitemap")
    int getChildrenCount();

    @Description("Тип файла sitemap")
    ApiSitemapType getSitemapType();
}
