package ru.yandex.webmaster3.api.sitemap.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public interface UserAddedSitemapError extends ApiErrorResponse<UserAddedSitemapError.Codes> {
    enum Codes implements ApiErrorCode {
        SITEMAP_NOT_ADDED,
    }

    @Description("Указанный сайтмеп отсутствует в коллекции добавленных пользователем сайтмепов для сайта")
    class SitemapNotAddedError extends ApiResponse.NotFound404<Codes> implements UserAddedSitemapError {
        private final WebmasterHostId hostId;
        private final ApiSitemapId sitemapId;

        public SitemapNotAddedError(WebmasterHostId hostId, ApiSitemapId sitemapId) {
            super(Codes.SITEMAP_NOT_ADDED, "Sitemap \"" + sitemapId + "\" is not added by user for host \"" + hostId + "\"");
            this.hostId = hostId;
            this.sitemapId = sitemapId;
        }

        @Description("id хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Description("id сайтмепа")
        public ApiSitemapId getSitemapId() {
            return sitemapId;
        }
    }
}
