package ru.yandex.webmaster3.api.tic.action;

import org.joda.time.DateTime;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.common.data.ApiHistoryPoint;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.TimeUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
@Description("Получить историю значений тИЦ для сайта")
@Category("tic")
@Component
public class TicHistoryAction extends AbstractApiAction<TicHistoryRequest, TicHistoryResponse> {
    public TicHistoryAction() {
        super(Permission.COMMON);
    }

    /**
     * Тиц уже давно не поддерживается, поэтому возвращаем 0 для тех упрямцев,
     * которые до сих пор используют эту ручку.
     */
    @Override
    public TicHistoryResponse process(TicHistoryRequest request) {
        var now = DateTime.now();

        var dateTo = request.getDateToOrNow();
        if (dateTo.isAfter(now)) {
            dateTo = now;
        }
        dateTo = dateTo.withTimeAtStartOfDay();

        var dateFrom = request.getDateFromOrNow().withTimeAtStartOfDay();

        if (dateFrom.isAfter(dateTo)) {
            dateFrom = dateTo.minusDays(1);
        }

        List<ApiHistoryPoint<Long>> result = new ArrayList<>();
        for (DateTime d = dateFrom; d.isBefore(dateTo) || d.isEqual(dateTo); d = d.plusDays(1)) {
            result.add(new ApiHistoryPoint<>(d.withZone(TimeUtils.EUROPE_MOSCOW_ZONE), 0L));
        }

        return new TicHistoryResponse(result);
    }
}
