package ru.yandex.webmaster3.api.tic.action;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiDateRangeRequest;
import ru.yandex.webmaster3.api.tic.TicHistoryLocator;
import ru.yandex.webmaster3.storage.host.HostDataState;

/**
 * @author avhaliullin
 */
public class TicHistoryRequest extends AbstractApiUserVerifiedHostRequest<TicHistoryLocator>
        implements IndexedHostRequest, ApiDateRangeRequest {
    private HostDataState hostDataState;
    private DateTime dateFrom;
    private DateTime dateTo;

    @Override
    public HostDataState getHostDataState() {
        return hostDataState;
    }

    @Override
    public void setHostDataState(HostDataState hostDataState) {
        this.hostDataState = hostDataState;
    }

    @Override
    public DateTime getDateFrom() {
        return dateFrom;
    }

    @Override
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public DateTime getDateTo() {
        return dateTo;
    }

    @Override
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }
}
