package ru.yandex.webmaster3.api.turbo;

import org.joda.time.Instant;
import ru.yandex.webmaster3.api.http.common.request.locator.AbstractHostLocator;
import ru.yandex.webmaster3.api.turbo.action.TurboPushMode;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class UploadTurboTaskLocator extends AbstractHostLocator {
    private final TurboPushMode mode;
    private final Instant validUntil;
    public UploadTurboTaskLocator(long userId, WebmasterHostId hostId, TurboPushMode mode, Instant validUntil) {
        super(userId, hostId);
        this.mode = mode;
        this.validUntil = validUntil;
    }

    public TurboPushMode getMode() {
        return mode;
    }

    public Instant getValidUntil() {
        return validUntil;
    }
}
