package ru.yandex.webmaster3.api.turbo.action;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.metrics.Category;

/**
 * @author avhaliullin
 */
@Category("turbo")
@Description("Получить адрес для создания турбо-задач")
@Component
public class GetTaskUploadAddressAction extends AbstractApiAction<GetTaskUploadAddressRequest, GetTaskUploadAddressResponse> {
    private static final Duration ADDRESS_TTL = Duration.standardMinutes(10);

    public GetTaskUploadAddressAction() {
        super(Permission.TURBO);
    }

    @Override
    public GetTaskUploadAddressResponse process(GetTaskUploadAddressRequest request) {
        return new GetTaskUploadAddressResponse(request.getUserId(), request.getHostId(), request.getMode(), Instant.now().plus(ADDRESS_TTL));
    }
}
