package ru.yandex.webmaster3.api.turbo.action;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.meta.ResponseWithLocation;
import ru.yandex.webmaster3.api.turbo.UploadTurboTaskLocator;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class GetTaskUploadAddressResponse extends ApiResponse.Success200 implements ResponseWithLocation<UploadTurboTaskLocator> {
    private final UploadTurboTaskLocator locator;
    private final DateTime validUntil;

    public GetTaskUploadAddressResponse(long userId, WebmasterHostId hostId, TurboPushMode mode, Instant validUntil) {
        this.locator = new UploadTurboTaskLocator(userId, hostId, mode, validUntil);
        this.validUntil = new DateTime(validUntil);
    }

    @Description("Адрес для совершения POST-запроса для создания задачи")
    public UploadTurboTaskLocator getUploadAddress() {
        return locator;
    }

    @Description("Время устаривания адреса для загрузки")
    public DateTime getValidUntil() {
        return validUntil;
    }

    @Override
    public UploadTurboTaskLocator getLocation() {
        return locator;
    }
}
