package ru.yandex.webmaster3.api.turbo.action;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.turbo.data.TurboPushProcessStatus;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboApiTaskWithResult;

import java.util.List;
import java.util.UUID;

/**
 * Created by ifilippov5 on 29.05.18.
 */
public interface GetTurboPushListResponse extends ApiGetResponse {
    class NormalResponse extends Success200 implements GetTurboPushListResponse {
        private final List<ListItem> tasks;
        private final int count;

        public NormalResponse(List<ListItem> tasks, int count) {
            this.tasks = tasks;
            this.count = count;
        }

        @Description("Список задач на добавление турбо-страниц")
        public List<ListItem> getTasks() {
            return tasks;
        }

        @Description("Общее количество задач")
        public int getCount() {
            return count;
        }
    }

    class ListItem {
        private final UUID taskId;
        private final DateTime createdAt;
        private final TurboPushProcessStatus loadStatus;

        public ListItem(TurboApiTaskWithResult task) {
            this(task.getTaskId(), task.getAddDate(), TurboPushProcessStatus.fromTaskState(task.getState()));
        }

        public ListItem(UUID taskId, DateTime createdAt, TurboPushProcessStatus loadStatus) {
            this.taskId = taskId;
            this.createdAt = createdAt;
            this.loadStatus = loadStatus;
        }

        @Description("Идентификатор задачи")
        public UUID getTaskId() {
            return taskId;
        }

        @Description("Дата создания задачи")
        public DateTime getCreatedAt() {
            return createdAt;
        }

        @Description("Статус обработки задачи")
        public TurboPushProcessStatus getLoadStatus() {
            return loadStatus;
        }
    }
}
