package ru.yandex.webmaster3.api.turbo.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.ActionPermission;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.core.metrics.Category;

import java.util.UUID;

import org.springframework.stereotype.Component;

/**
 * Created by ifilippov5 on 23.05.18.
 */
@Component
@Category("turbo")
@Description("Возвращает статус пуша")
@ActionPermission(Permission.TURBO)
public class GetTurboPushTaskStatusAction extends AbstractGetTurboPushTaskStatusAction<GetTurboPushTaskStatusResponse> {
    @Override
    protected GetTurboPushTaskStatusResponse renderNormalResponse(GetTurboPushTaskStatusResponse.NormalResponse response) {
        return response;
    }

    @Override
    protected GetTurboPushTaskStatusResponse renderTaskNotFoundResponse(UUID pushId) {
        return new GetTurboPushTaskStatusResponse.ResourceNotFoundError(String.valueOf(pushId));
    }
}
