package ru.yandex.webmaster3.api.turbo.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.turbo.data.TurboError;
import ru.yandex.webmaster3.api.turbo.data.TurboPage;
import ru.yandex.webmaster3.api.turbo.data.TurboPagesStatistics;
import ru.yandex.webmaster3.api.turbo.data.TurboPushProcessStatus;

import java.util.List;

/**
 * Created by ifilippov5 on 23.05.18.
 */
public interface GetTurboPushTaskStatusResponse extends ApiGetResponse {
    class NormalResponse extends Success200 implements GetTurboPushTaskStatusResponse {
        private final TurboPushMode mode;
        private final TurboPushProcessStatus loadStatus;
        private final List<TurboPage> turboPages;
        private final List<TurboError> errors;
        private final TurboPagesStatistics stats;

        public NormalResponse(TurboPushMode mode, TurboPushProcessStatus loadStatus, List<TurboPage> turboPages, List<TurboError> errors, TurboPagesStatistics stats) {
            this.mode = mode;
            this.loadStatus = loadStatus;
            this.turboPages = turboPages;
            this.errors = errors;
            this.stats = stats;
        }

        @Description("Режим загрузки страниц")
        public TurboPushMode getMode() {
            return mode;
        }

        @Description("Статус загрузки страниц")
        public TurboPushProcessStatus getLoadStatus() {
            return loadStatus;
        }

        @Description("Турбо страницы")
        public List<TurboPage> getTurboPages() {
            return turboPages;
        }

        @Description("Ошибки")
        public List<TurboError> getErrors() {
            return errors;
        }

        @Description("Общая статистика пуша")
        public TurboPagesStatistics getStats() {
            return stats;
        }
    }

    enum Errors implements ApiErrorCode {
        TASK_NOT_FOUND,
    }

    @Description("Запрошенная задача не найдена")
    class ResourceNotFoundError extends NotFound404<Errors> implements GetTurboPushTaskStatusResponse {
        public ResourceNotFoundError(String message) {
            super(Errors.TASK_NOT_FOUND, message);
        }
    }
}
