package ru.yandex.webmaster3.api.turbo.action.v31;

import org.springframework.http.MediaType;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.RawStringRequestContent;
import ru.yandex.webmaster3.api.http.rest.request.meta.ApiRequestWithRawContent;
import ru.yandex.webmaster3.api.turbo.UploadTurboTaskLocator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by Oleg Bazdyrev on 22/08/2017.
 */
public class AddTurboPagesV31Request extends AbstractApiUserVerifiedHostRequest<UploadTurboTaskLocator>
        implements ApiRequestWithRawContent {

    private RawStringRequestContent entity;

    @Description("Турбо страницы")
    @Override
    public RawStringRequestContent getEntity() {
        return entity;
    }

    @Override
    public void setEntity(RawStringRequestContent turboPagePayload) {
        this.entity = turboPagePayload;
    }

    @Override
    public Set<MediaType> allowedMediaTypes() {
        return new HashSet<>(Arrays.asList(
                MediaType.MULTIPART_FORM_DATA,
                MediaType.parseMediaType("application/rss+xml"))
        );
    }

    @Override
    public Set<MediaType> allowedPartMediaTypes() {
        return new HashSet<>(Collections.singletonList(
                MediaType.parseMediaType("application/rss+xml"))
        );
    }
}
