package ru.yandex.webmaster3.api.turbo.action.v31;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiPaginationRequest;
import ru.yandex.webmaster3.api.turbo.TurboPagesLocator;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;

/**
 * Created by ifilippov5 on 29.05.18.
 */
public class GetTurboPushListV31Request extends AbstractApiUserVerifiedHostRequest<TurboPagesLocator>
        implements ApiPaginationRequest {
    private int offset = 0;
    private int limit = 100;
    private TaskTypeFilter taskTypeFilter = TaskTypeFilter.ALL;

    @Override
    public int getOffset() {
        return offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLimit() {
        return limit;
    }

    @Override
    @MaxValue(100)
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public TaskTypeFilter getTaskTypeFilter() {
        return taskTypeFilter;
    }

    @Description("Фильтр по режиму загрузки")
    @RequestQueryProperty
    public void setTaskTypeFilter(TaskTypeFilter taskTypeFilter) {
        this.taskTypeFilter = taskTypeFilter;
    }

    @Getter
    @AllArgsConstructor
    public enum TaskTypeFilter {
        DEBUG(false),
        PRODUCTION(true),
        ALL(null);

        private final Boolean value;

    }
}
