package ru.yandex.webmaster3.api.turbo.action.v31;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;

import java.util.List;
import java.util.UUID;

/**
 * Created by ifilippov5 on 29.05.18.
 */
public interface GetTurboPushListV31Response extends ApiGetResponse {
    class NormalResponse extends ApiGetResponse.Success200 implements GetTurboPushListV31Response {
        private final List<ListItem> tasks;
        private final int count;

        public NormalResponse(List<ListItem> tasks, int count) {
            this.tasks = tasks;
            this.count = count;
        }

        @Description("Список задач на добавление турбо-страниц")
        public List<ListItem> getTasks() {
            return tasks;
        }

        @Description("Общее количество задач")
        public int getCount() {
            return count;
        }
    }

    class ListItem {
        private final UUID taskId;

        public ListItem(UUID taskId) {
            this.taskId = taskId;
        }

        @Description("Идентификатор задачи")
        public UUID getTaskId() {
            return taskId;
        }
    }
}
