package ru.yandex.webmaster3.api.turbo.action.v31;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.ActionPermission;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.turbo.action.AbstractGetTurboPushTaskStatusAction;
import ru.yandex.webmaster3.api.turbo.action.GetTurboPushTaskStatusResponse;
import ru.yandex.webmaster3.api.turbo.data.v31.TurboErrorV31;
import ru.yandex.webmaster3.core.metrics.Category;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.stereotype.Component;

/**
 * Created by ifilippov5 on 23.05.18.
 */
@Component
@Category("turbo")
@Description("Возвращает статус пуша")
@ActionPermission(Permission.TURBO)
public class GetTurboPushTaskStatusV31Action extends AbstractGetTurboPushTaskStatusAction<GetTurboPushTaskStatusV31Response> {
    @Override
    protected GetTurboPushTaskStatusV31Response renderNormalResponse(GetTurboPushTaskStatusResponse.NormalResponse response) {
        List<TurboErrorV31> mappedErrors = response.getErrors().stream()
                .map(e -> new TurboErrorV31(e.getHelpLink(), e.getLine(), e.getColumn(), e.getText()))
                .collect(Collectors.toList());
        return new GetTurboPushTaskStatusV31Response.NormalResponse(response.getMode(), response.getLoadStatus(), response.getTurboPages(), mappedErrors, response.getStats());
    }

    @Override
    protected GetTurboPushTaskStatusV31Response renderTaskNotFoundResponse(UUID pushId) {
        return new GetTurboPushTaskStatusV31Response.ResourceNotFoundError(String.valueOf(pushId));
    }
}
