package ru.yandex.webmaster3.api.turbo.action.v31;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.turbo.action.TurboPushMode;
import ru.yandex.webmaster3.api.turbo.data.TurboPage;
import ru.yandex.webmaster3.api.turbo.data.TurboPagesStatistics;
import ru.yandex.webmaster3.api.turbo.data.TurboPushProcessStatus;
import ru.yandex.webmaster3.api.turbo.data.v31.TurboErrorV31;

import java.util.List;

/**
 * Created by ifilippov5 on 23.05.18.
 */
public interface GetTurboPushTaskStatusV31Response extends ApiGetResponse {
    class NormalResponse extends Success200 implements GetTurboPushTaskStatusV31Response {
        private final TurboPushMode mode;
        private final TurboPushProcessStatus loadStatus;
        private final List<TurboPage> turboPages;
        private final List<TurboErrorV31> errors;
        private final TurboPagesStatistics stats;

        public NormalResponse(TurboPushMode mode, TurboPushProcessStatus loadStatus, List<TurboPage> turboPages, List<TurboErrorV31> errors, TurboPagesStatistics stats) {
            this.mode = mode;
            this.loadStatus = loadStatus;
            this.turboPages = turboPages;
            this.errors = errors;
            this.stats = stats;
        }

        @Description("Режим загрузки страниц")
        public TurboPushMode getMode() {
            return mode;
        }

        @Description("Статус загрузки страниц")
        public TurboPushProcessStatus getLoadStatus() {
            return loadStatus;
        }

        @Description("Турбо страницы")
        public List<TurboPage> getTurboPages() {
            return turboPages;
        }

        @Description("Ошибки")
        public List<TurboErrorV31> getErrors() {
            return errors;
        }

        @Description("Общая статистика пуша")
        public TurboPagesStatistics getStats() {
            return stats;
        }
    }

    enum Errors implements ApiErrorCode {
        TASK_NOT_FOUND,
    }

    @Description("Запрошенная задача не найдена")
    class ResourceNotFoundError extends NotFound404<Errors> implements GetTurboPushTaskStatusV31Response {
        public ResourceNotFoundError(String message) {
            super(Errors.TASK_NOT_FOUND, message);
        }
    }
}
