package ru.yandex.webmaster3.api.turbo.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.turbo.TurboApiErrorType;

import java.util.Optional;

public class TurboError {
    private final TurboApiErrorType errorCode;
    private final String helpLink;
    private final Optional<Integer> line;
    private final Optional<Integer> column;
    private final Optional<String> text;
    private final Optional<TurboErrorContext> context;
    private final Optional<String> tag;

    public TurboError(TurboApiErrorType errorCode, String helpLink, Optional<Integer> line, Optional<Integer> column,
                      Optional<String> text, Optional<TurboErrorContext> context, Optional<String> tag) {
        this.errorCode = errorCode;
        this.helpLink = helpLink;
        this.line = line;
        this.column = column;
        this.text = text;
        this.context = context;
        this.tag = tag;
    }

    @Description("Код ошибки, список кодов ошибок может расширяться")
    public TurboApiErrorType getErrorCode() {
        return errorCode;
    }

    @Description("Ссылка на описание ошибки в хелпе")
    public String getHelpLink() {
        return helpLink;
    }

    @Description("Номер строки с ошибкой")
    public Optional<Integer> getLine() {
        return line;
    }

    @Description("Номер столбца (позиция в строке) с ошибкой")
    public Optional<Integer> getColumn() {
        return column;
    }

    @Description("Строка с ошибкой")
    public Optional<String> getText() {
        return text;
    }

    @Description("Контекст возникновения ошибки")
    public Optional<TurboErrorContext> getContext() {
        return context;
    }

    @Description("Имя тега, в котором обнаружена ошибка")
    public Optional<String> getTag() {
        return tag;
    }
}
