package ru.yandex.webmaster3.api.turbo.data;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboCrawlState;

/**
 * @author avhaliullin
 */
@Getter
@AllArgsConstructor
public enum TurboPushProcessStatus {
    @Description("задача в обработке")
    PROCESSING(TurboCrawlState.PROCESSING),
    @Description("задача обработана успешно")
    OK(TurboCrawlState.OK),
    @Description("задача обработана с пердупреждениями")
    WARNING(TurboCrawlState.WARNING),
    @Description("обработка задачи завершилась с ошибками")
    ERROR(TurboCrawlState.ERROR),
    ;

    private final TurboCrawlState state;

    public static TurboPushProcessStatus fromTaskState(TurboCrawlState state) {
        if (state == null) {
            return PROCESSING;
        }
        switch (state) {
            case ERROR:
                return ERROR;
            case OK:
                return OK;
            case WARNING:
                return WARNING;
            case PROCESSING:
                return PROCESSING;
            default:
                throw new RuntimeException("Unknown task status");
        }
    }
}
