package ru.yandex.webmaster3.api.turbo.data.v31;

import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.Optional;

public class TurboErrorV31 {
    private final String helpLink;
    private final Optional<Integer> line;
    private final Optional<Integer> column;
    private final Optional<String> text;

    public TurboErrorV31(String helpLink, Optional<Integer> line, Optional<Integer> column, Optional<String> text) {
        this.helpLink = helpLink;
        this.line = line;
        this.column = column;
        this.text = text;
    }

    @Description("Ссылка на описание ошибки в хелпе")
    public String getHelpLink() {
        return helpLink;
    }

    @Description("Номер строки с ошибкой")
    public Optional<Integer> getLine() {
        return line;
    }

    @Description("Номер столбца с ошибкой")
    public Optional<Integer> getColumn() {
        return column;
    }

    @Description("Строка с ошибкой")
    public Optional<String> getText() {
        return text;
    }
}
