package ru.yandex.webmaster3.api.user.action;

import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.metrics.Category;

/**
 * @author avhaliullin
 */
@Description("Получить идентификатор пользователя")
@Category("user")
@Component
public class GetUserAction extends AbstractApiAction<GetUserRequest, GetUserResponse> {
    public GetUserAction() {
        super(Permission.ALL_SCOPES);
    }

    @Override
    public GetUserResponse process(GetUserRequest request) {
        return new GetUserResponse(request.getAuthorizedUserId());
    }
}
