package ru.yandex.webmaster3.api.user.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;

/**
 * @author avhaliullin
 */
public interface UserIdAccessAuthorizedError extends ApiErrorResponse<UserIdAccessAuthorizedError.Codes> {
    enum Codes implements ApiErrorCode {
        INVALID_USER_ID,
    }

    @Description("id пользователя, выдавшего токен доступа, отличается от id пользователя, указанного в запросе")
    class InvalidUserIdError extends ApiResponse.Forbidden403<Codes> implements UserIdAccessAuthorizedError {
        private final long availableUserId;

        public InvalidUserIdError(long availableUserId) {
            super(Codes.INVALID_USER_ID, "Invalid user id. " + availableUserId +" should be used");
            this.availableUserId = availableUserId;
        }

        @Description("id пользователя, от имени которого разрешен доступ")
        public long getAvailableUserId() {
            return availableUserId;
        }
    }
}
