package ru.yandex.webmaster3.api.user.filter;

import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestFilter;

/**
 * @author avhaliullin
 */
public class UserIdAccessAuthorizedFilter<Req extends ApiRequest<?> & ApiUserIdAwareRequest>
        implements ApiRequestFilter<Req, UserIdAccessAuthorizedError> {
    @Override
    public UserIdAccessAuthorizedError applyFilter(Req req) {
        long authorizedUser = req.getAuthorizedUserId();
        long requestedUser = req.getUserId();
        if (authorizedUser != requestedUser) {
            return new UserIdAccessAuthorizedError.InvalidUserIdError(authorizedUser);
        }
        return null;
    }
}
