package ru.yandex.webmaster3.api.verification.action;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.verification.data.ApiExplicitVerificationType;
import ru.yandex.webmaster3.api.verification.data.ApiVerificationFailInfo;
import ru.yandex.webmaster3.api.verification.data.ApiVerificationState;
import ru.yandex.webmaster3.api.verification.data.ApiVerificationType;

import java.util.Optional;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class HostVerificationInfoResponse extends ApiResponse.Success200 {
    private final String verificationUin;
    private final ApiVerificationState verificationState;
    private final Optional<ApiVerificationType> verificationType;
    private final Optional<DateTime> latestVerificationTime;
    private final Optional<ApiVerificationFailInfo> failInfo;
    private final Set<ApiExplicitVerificationType> applicableVerifiers;

    public HostVerificationInfoResponse(String verificationUin, ApiVerificationState verificationState,
                                        Optional<ApiVerificationType> verificationType,
                                        Optional<DateTime> latestVerificationTime,
                                        Optional<ApiVerificationFailInfo> failInfo,
                                        Set<ApiExplicitVerificationType> applicableVerifiers) {
        this.verificationUin = verificationUin;
        this.verificationState = verificationState;
        this.verificationType = verificationType;
        this.latestVerificationTime = latestVerificationTime;
        this.failInfo = failInfo;
        this.applicableVerifiers = applicableVerifiers;
    }

    @Description("код подтверждения")
    public String getVerificationUin() {
        return verificationUin;
    }

    @Description("состояние подтверждения прав")
    public ApiVerificationState getVerificationState() {
        return verificationState;
    }

    @Description("способ подтверждения (если state не NONE)")
    public Optional<ApiVerificationType> getVerificationType() {
        return verificationType;
    }

    @Description("время последней проверки (если state не NONE)")
    public Optional<DateTime> getLatestVerificationTime() {
        return latestVerificationTime;
    }

    @Description("описание ошибки (если VERIFICATION_FAILED)")
    public Optional<ApiVerificationFailInfo> getFailInfo() {
        return failInfo;
    }

    @Description("способы подтверждения, применимые для выбранного сайта")
    public Set<ApiExplicitVerificationType> getApplicableVerifiers() {
        return applicableVerifiers;
    }
}
