package ru.yandex.webmaster3.api.verification.action;

import java.util.Optional;
import java.util.Set;

import org.joda.time.DateTime;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiPostResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.verification.data.ApiExplicitVerificationType;
import ru.yandex.webmaster3.api.verification.data.ApiVerificationFailInfo;
import ru.yandex.webmaster3.api.verification.data.ApiVerificationState;
import ru.yandex.webmaster3.api.verification.data.ApiVerificationType;

/**
 * @author avhaliullin
 */
public interface VerifyHostResponse extends ApiPostResponse {
    class NormalResponse extends Success200 implements VerifyHostResponse {
        private final String verificationUin;
        private final ApiVerificationState verificationState;
        private final Optional<ApiVerificationType> verificationType;
        private final Optional<DateTime> latestVerificationTime;
        private final Optional<ApiVerificationFailInfo> failInfo;
        private final Set<ApiExplicitVerificationType> applicableVerifiers;

        public NormalResponse(String verificationUin, ApiVerificationState verificationState,
                                            Optional<ApiVerificationType> verificationType,
                                            Optional<DateTime> latestVerificationTime,
                                            Optional<ApiVerificationFailInfo> failInfo,
                                            Set<ApiExplicitVerificationType> applicableVerifiers) {
            this.verificationUin = verificationUin;
            this.verificationState = verificationState;
            this.verificationType = verificationType;
            this.latestVerificationTime = latestVerificationTime;
            this.failInfo = failInfo;
            this.applicableVerifiers = applicableVerifiers;
        }

        @Description("код подтверждения")
        public String getVerificationUin() {
            return verificationUin;
        }

        @Description("состояние подтверждения прав")
        public ApiVerificationState getVerificationState() {
            return verificationState;
        }

        @Description("способ подтверждения (если state не NONE)")
        public Optional<ApiVerificationType> getVerificationType() {
            return verificationType;
        }

        @Description("время последней проверки (если state не NONE)")
        public Optional<DateTime> getLatestVerificationTime() {
            return latestVerificationTime;
        }

        @Description("описание ошибки (если VERIFICATION_FAILED)")
        public Optional<ApiVerificationFailInfo> getFailInfo() {
            return failInfo;
        }

        @Description("способы подтверждения, применимые для выбранного сайта")
        public Set<ApiExplicitVerificationType> getApplicableVerifiers() {
            return applicableVerifiers;
        }
    }

    enum Errors implements ApiErrorCode {
        VERIFICATION_ALREADY_IN_PROGRESS,
        NO_VERIFICATION_RECORD,
    }

    @Description("Процесс подтверждения прав уже идет")
    class VerificationAlreadyInProgress extends Conflict409<Errors> implements VerifyHostResponse {
        private final ApiExplicitVerificationType verificationType;

        public VerificationAlreadyInProgress(ApiExplicitVerificationType verificationType) {
            super(Errors.VERIFICATION_ALREADY_IN_PROGRESS, "Verification already in progress");
            this.verificationType = verificationType;
        }

        @Description("Тип подтверждения, которое сейчас в процессе")
        public ApiExplicitVerificationType getVerificationType() {
            return verificationType;
        }
    }

    @Description("Перед подтверждением необходимо получить уникальный код")
    class NoVerificationRecord extends UnprocessableEntity422<Errors> implements VerifyHostResponse {
        public NoVerificationRecord() {
            super(Errors.NO_VERIFICATION_RECORD, "You need to get a verification UIN using GET request BEFORE verification");
        }
    }
}
