package ru.yandex.webmaster3.api.verification.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationType;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

/**
 * @author avhaliullin
 */
public enum ApiExplicitVerificationType {
    @Description("подтверждение мета-тегом")
    META_TAG(VerificationType.META_TAG),
    @Description("подтверждение HTML-файлом")
    HTML_FILE(VerificationType.HTML_FILE),
    @Description("подтверждение записью в DNS")
    DNS(VerificationType.DNS),
    @Description("подтверждение через подтвержденный email в WHOIS")
    WHOIS(VerificationType.WHOIS),;

    private final VerificationType verificationType;

    ApiExplicitVerificationType(VerificationType verificationType) {
        this.verificationType = verificationType;
    }

    public VerificationType getVerificationType() {
        return verificationType;
    }

    public static ApiExplicitVerificationType fromVerificationTypeOrNull(VerificationType verificationType) {
        if (!verificationType.isExplicit() || !verificationType.isDisplayable()) {
            return null;
        }
        for (ApiExplicitVerificationType verifierType : values()) {
            if (verifierType.verificationType == verificationType) {
                return verifierType;
            }
        }
        return null;
    }

    public static Set<ApiExplicitVerificationType> fromVerificationTypes(Collection<VerificationType> verificationTypes) {
        EnumSet<ApiExplicitVerificationType> result = EnumSet.noneOf(ApiExplicitVerificationType.class);
        for (VerificationType verificationType : verificationTypes) {
            ApiExplicitVerificationType verifierType = ApiExplicitVerificationType.fromVerificationTypeOrNull(verificationType);
            if (verifierType != null) {
                result.add(verifierType);
            }
        }
        return result;
    }
}
