package ru.yandex.webmaster3.api.verification.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author avhaliullin
 */
public class ApiUserVerifiedHost {
    private final String userLogin;
    private final String verificationUin;
    private final ApiVerificationType verificationType;
    private final DateTime verificationDate;

    public ApiUserVerifiedHost(String userLogin, String verificationUin, ApiVerificationType verificationType,
                               DateTime verificationDate) {
        this.userLogin = userLogin;
        this.verificationUin = verificationUin;
        this.verificationType = verificationType;
        this.verificationDate = verificationDate;
    }

    @Description("логин пользователя")
    public String getUserLogin() {
        return userLogin;
    }

    @Description("код подтверждения")
    public String getVerificationUin() {
        return verificationUin;
    }

    @Description("способ подтверждения")
    public ApiVerificationType getVerificationType() {
        return verificationType;
    }

    @Description("дата подтверждения")
    public DateTime getVerificationDate() {
        return verificationDate;
    }
}
