package ru.yandex.webmaster3.api.verification.data;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author avhaliullin
 */
public enum ApiVerificationFailReason {
    @Description("нужный мета-тег не найден на главной")
    META_TAG_NOT_FOUND,
    @Description("запрашиваемая страница оказалась недоступна")
    PAGE_UNAVAILABLE,
    @Description("отсутствует необходимое содержимое html-файла")
    WRONG_HTML_PAGE_CONTENT,
    @Description("не найдена нужная запись в DNS")
    DNS_RECORD_NOT_FOUND,
    @Description("данный способ подтверждения неприменим для этого сайта")
    NOT_APPLICABLE,
    @Description("в whois не найден подтвержденный пользователем email")
    WHOIS_EMAIL_NOT_FOUND,
    @Description("делегирование прав было отменено")
    DELEGATION_CANCELLED,
    @Description("сайт больше не подтвержден в сервисе Я.Почта Для Домена")
    PDD_VERIFICATION_CANCELLED,

}
