package ru.yandex.webmaster3.api.verification.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationStatus;

/**
 * @author avhaliullin
 */
public enum ApiVerificationState {
    @Description("проверка не проводилась, права не подтверждены")
    NONE,
    @Description("права подтверждены")
    VERIFIED,
    @Description("подтверждение прав в процессе")
    IN_PROGRESS,
    @Description("права не подтверждены")
    VERIFICATION_FAILED,
    @Description("в процессе проверки прав произошла непредвиденная ошибка")
    INTERNAL_ERROR,;

    public static ApiVerificationState fromVerificationStatus(VerificationStatus status) {
        if (status == null) {
            return NONE;
        }
        switch (status) {
            case IN_PROGRESS:
                return IN_PROGRESS;
            case INTERNAL_ERROR:
                return INTERNAL_ERROR;
            case VERIFICATION_FAILED:
                return VERIFICATION_FAILED;
            case VERIFIED:
                return VERIFIED;
            default:
                throw new RuntimeException("Unknown verification status " + status);
        }
    }
}
