package ru.yandex.webmaster3.api.verification.data;

import org.jetbrains.annotations.NotNull;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationType;

/**
 * @author avhaliullin
 */
public enum ApiVerificationType {
    @Description("подтверждение мета-тегом")
    META_TAG,
    @Description("подтверждение HTML-файлом")
    HTML_FILE,
    @Description("подтверждение записью в DNS")
    DNS,
    @Description("подтверждение через подтвержденный email в WHOIS")
    WHOIS,
    @Description("права делегированы")
    DELEGATED,
    @Description("подтверждение через Яндекс.Почту Для Домена")
    PDD,
    @Description("автоподтверждение (устаревшее - для сайтов <login>.narod.ru)")
    AUTO
    ;

    public static ApiVerificationType fromVerificationType(@NotNull VerificationType verificationType) {
        switch (verificationType) {
            case AUTO:
                return AUTO;
            case DELEGATED:
                return DELEGATED;
            case DNS:
                return DNS;
            case HTML_FILE:
                return HTML_FILE;
            case META_TAG:
                return META_TAG;
            case PDD:
                return PDD;
            case WHOIS:
                return WHOIS;
            // Не палимся
            case IDM:
            case UNKNOWN:
            case SELF:
                return META_TAG;
            default:
                throw new RuntimeException("Unknown verification type " + verificationType);
        }
    }
}
